<?php
session_start();
include('../header.php');

$service_fee = 15; // ₹15 for all in one panel

// Helper: get fresh wallet balance
function get_panel_balance($conn, $phone) {
    $phone_safe = mysqli_real_escape_string($conn, $phone);
    $res = mysqli_query($conn, "SELECT balance FROM users WHERE phone='$phone_safe' LIMIT 1");
    if ($res && mysqli_num_rows($res) > 0) {
        $row = mysqli_fetch_assoc($res);
        return (float)$row['balance'];
    }
    return 0.0;
}

// Get current balance
$panel_phone = isset($udata['phone']) ? $udata['phone'] : '';
$current_balance = get_panel_balance($ahk_conn, $panel_phone);

// Check if this is a POST request for AJAX
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['download'])) {
    // Start output buffering and clear any previous output
    while (ob_get_level()) {
        ob_end_clean();
    }
    ob_start();
    
    // Set JSON header
    header('Content-Type: application/json');
    
    $rasan_no = isset($_POST['rasan_no']) ? trim($_POST['rasan_no']) : '';
    $type = isset($_POST['type']) ? $_POST['type'] : 'old';
    
    if (empty($rasan_no)) {
        echo json_encode(['success' => false, 'message' => 'Please enter Ration Number']);
        exit;
    }
    
    if (empty($panel_phone)) {
        echo json_encode(['success' => false, 'message' => 'User data not found. Please login again.']);
        exit;
    }
    
    // Check balance before proceeding
    $wallet_balance = get_panel_balance($ahk_conn, $panel_phone);
    if ($wallet_balance < $service_fee) {
        echo json_encode([
            'success' => false, 
            'message' => "Insufficient Balance. Required ₹$service_fee | Available ₹" . number_format($wallet_balance, 2)
        ]);
        exit;
    }
    
    // API CALL
    $api_key = "enter api key"; // Admin API Key
    $api_url = "https://lostdata.co.in/api/ration-pdf.php";
    
    $api_params = [
        'rasan_no' => $rasan_no,
        'type' => $type,
        'api_key' => $api_key
    ];
    
    $api_url_with_params = $api_url . '?' . http_build_query($api_params);
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url_with_params);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 60);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    
    $api_response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $curl_error = curl_error($ch);
    curl_close($ch);
    
    // Check for errors
    if ($curl_error || $http_code != 200) {
        echo json_encode([
            'success' => false,
            'message' => $curl_error ? 'Connection Error: ' . $curl_error : "API Error (HTTP $http_code)"
        ]);
        exit;
    }
    
    // Check if response is direct PDF
    $is_pdf = (substr($api_response, 0, 4) === '%PDF');
    $pdf_base64 = '';
    
    if ($is_pdf) {
        // Direct PDF received - convert to base64
        $pdf_base64 = base64_encode($api_response);
        $pdf_content = $api_response;
    } else {
        // Try to parse as JSON
        $json_response = json_decode($api_response, true);
        
        if (!$json_response) {
            echo json_encode(['success' => false, 'message' => 'Invalid response from API']);
            exit;
        }
        
        if (isset($json_response['success']) && $json_response['success'] === true && isset($json_response['data']['pdf_base64'])) {
            $pdf_base64 = $json_response['data']['pdf_base64'];
            $pdf_content = base64_decode($pdf_base64, true);
            
            if ($pdf_content === false || empty($pdf_content) || substr($pdf_content, 0, 4) !== '%PDF') {
                echo json_encode(['success' => false, 'message' => 'Invalid PDF data received']);
                exit;
            }
        } else {
            // Error response from API
            $error_message = 'Unknown error';
            if (isset($json_response['message'])) {
                $error_message = $json_response['message'];
            } elseif (isset($json_response['error'])) {
                $error_message = $json_response['error'];
            }
            echo json_encode(['success' => false, 'message' => $error_message]);
            exit;
        }
    }
    
    // If we reach here, we have valid PDF - deduct wallet balance
    $phone_safe = mysqli_real_escape_string($ahk_conn, $panel_phone);
    mysqli_begin_transaction($ahk_conn);
    
    try {
        // Deduct balance
        $upd = mysqli_query(
            $ahk_conn,
            "UPDATE users SET balance = balance - $service_fee 
             WHERE phone = '$phone_safe' AND balance >= $service_fee"
        );
        
        if (!$upd || mysqli_affected_rows($ahk_conn) === 0) {
            throw new Exception("Wallet deduction failed - insufficient balance");
        }
        
        // Get new balance
        $new_balance = get_panel_balance($ahk_conn, $panel_phone);
        
        // Add wallet history
        $purpose = mysqli_real_escape_string(
            $ahk_conn,
            "Ration PDF Download - Ration No: $rasan_no (₹$service_fee)"
        );
        
        $history_query = mysqli_query(
            $ahk_conn,
            "INSERT INTO wallethistory (userid, amount, balance, purpose, status, type, date)
             VALUES ('$phone_safe', '$service_fee', '$new_balance', '$purpose', '1', 'Debit', NOW())"
        );
        
        if (!$history_query) {
            throw new Exception("Failed to add wallet history");
        }
        
        mysqli_commit($ahk_conn);
        
        // Return success with PDF data
        echo json_encode([
            'success' => true,
            'message' => 'Ration PDF downloaded successfully. ₹' . $service_fee . ' deducted from your wallet.',
            'pdf_base64' => $pdf_base64,
            'filename' => "ration_$rasan_no.pdf",
            'new_balance' => $new_balance
        ]);
        exit;
        
    } catch (Exception $e) {
        mysqli_rollback($ahk_conn);
        echo json_encode([
            'success' => false,
            'message' => 'Transaction failed: ' . $e->getMessage()
        ]);
        exit;
    }
}

// For GET requests, show the form
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet" media="print" onload="this.media='all'">
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Poppins', sans-serif;
            background: #f1f3f6;
            min-height: 100vh;
            padding: 15px;
            overflow-x: hidden;
        }
        .main-container {
            max-width: 960px;
            margin: 15px auto;
            padding: 0 15px;
        }
        .service-card {
            background: #ffffff;
            border-radius: 18px;
            box-shadow: 0 18px 45px rgba(15, 23, 42, 0.15);
            padding: 28px 24px 26px;
            border: 1px solid #e3e6f0;
        }
        @media (min-width: 768px) {
            .main-container {
                max-width: 980px;
            }
            .service-card {
                padding: 32px 32px 30px;
            }
        }
        .service-header {
            text-align: center;
            margin-bottom: 30px;
        }
        .service-icon {
            width: 80px;
            height: 80px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
            box-shadow: 0 8px 20px rgba(102, 126, 234, 0.3);
        }
        .service-icon i {
            font-size: 36px;
            color: white;
        }
        .service-title {
            font-size: 24px;
            font-weight: 700;
            color: #1e293b;
            margin-bottom: 8px;
        }
        .service-subtitle {
            font-size: 14px;
            color: #64748b;
            margin-bottom: 15px;
        }
        .service-fee {
            display: inline-block;
            background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);
            color: white;
            padding: 8px 20px;
            border-radius: 20px;
            font-weight: 600;
            font-size: 16px;
        }
        .wallet-info {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            color: white;
            padding: 15px 20px;
            border-radius: 12px;
            margin-bottom: 25px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .wallet-info .balance-label {
            font-size: 14px;
            opacity: 0.9;
        }
        .wallet-info .balance-amount {
            font-size: 20px;
            font-weight: 700;
        }
        .form-group {
            margin-bottom: 20px;
        }
        .form-label {
            font-weight: 600;
            color: #1e293b;
            margin-bottom: 8px;
            display: block;
            font-size: 14px;
        }
        .form-control {
            height: 50px;
            border-radius: 12px;
            border: 2px solid #e2e8f0;
            padding: 12px 16px;
            font-size: 15px;
            transition: all 0.3s ease;
        }
        .form-control:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.1);
            outline: none;
        }
        .form-select {
            height: 50px;
            border-radius: 12px;
            border: 2px solid #e2e8f0;
            padding: 12px 16px;
            font-size: 15px;
            transition: all 0.3s ease;
        }
        .form-select:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.1);
            outline: none;
        }
        .btn-download {
            width: 100%;
            height: 52px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 12px;
            font-weight: 600;
            font-size: 16px;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            transition: all 0.3s ease;
            margin-top: 10px;
        }
        .btn-download:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(102, 126, 234, 0.3);
            color: white;
        }
        .btn-download:active {
            transform: translateY(0);
        }
        .info-box {
            background: #f8fafc;
            border-left: 4px solid #667eea;
            padding: 15px;
            border-radius: 8px;
            margin-top: 20px;
        }
        .info-box p {
            margin: 0;
            font-size: 14px;
            color: #64748b;
            line-height: 1.6;
        }
        .info-box i {
            color: #667eea;
            margin-right: 8px;
        }
        .loading-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.7);
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            color: white;
            z-index: 9999;
            display: none;
        }
        .spinner {
            width: 50px;
            height: 50px;
            border: 5px solid rgba(255, 255, 255, 0.3);
            border-radius: 50%;
            border-top-color: white;
            animation: spin 1s linear infinite;
            margin-bottom: 20px;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
    </style>
</head>
<body>

    <div class="loading-overlay" id="loadingOverlay">
        <div class="spinner"></div>
        <h4>Processing...</h4>
        <p>Downloading PDF and updating wallet, please wait...</p>
    </div>

    <div class="main-container">
        <div class="service-card">
            <div class="service-header">
                <div class="service-icon">
                    <i class="fas fa-file-pdf"></i>
                </div>
                <h1 class="service-title">Ration Card PDF Download</h1>
                <p class="service-subtitle">Download your ration card PDF instantly</p>
                <span class="service-fee">₹<?php echo $service_fee; ?> Only</span>
            </div>
            
            <div class="wallet-info">
                <span class="balance-label">
                    <i class="fas fa-wallet"></i> Your Wallet Balance
                </span>
                <span class="balance-amount" id="walletBalance">₹<?php echo number_format($current_balance, 2); ?></span>
            </div>
            
            <form id="downloadForm">
                <div class="form-group">
                    <label for="rasan_no" class="form-label">
                        <i class="fas fa-id-card"></i> Ration Number
                    </label>
                    <input 
                        type="text" 
                        class="form-control" 
                        id="rasan_no" 
                        name="rasan_no" 
                        placeholder="Enter Ration Number" 
                        required
                        autocomplete="off"
                    >
                </div>
                
                <div class="form-group">
                    <label for="type" class="form-label">
                        <i class="fas fa-list"></i> Card Type
                    </label>
                    <select class="form-select" id="type" name="type" required>
                        <option value="old">Old Ration Card</option>
                        <option value="new">New Ration Card</option>
                    </select>
                </div>
                
                <button type="submit" class="btn btn-download" id="downloadBtn">
                    <i class="fas fa-download"></i>
                    Download PDF (₹<?php echo $service_fee; ?>)
                </button>
            </form>
            
            <div class="info-box">
                <p>
                    <i class="fas fa-info-circle"></i>
                    <strong>Note:</strong> Enter your ration number and select card type. The PDF will be downloaded automatically after successful payment deduction of ₹<?php echo $service_fee; ?>.
                </p>
            </div>
        </div>
    </div>
    
    <script>
    $(document).ready(function() {
        $('#downloadForm').on('submit', function(e) {
            e.preventDefault();
            
            const rasanNo = $('#rasan_no').val().trim();
            const type = $('#type').val();
            
            if (!rasanNo) {
                alert('Please enter Ration Number');
                return;
            }
            
            // Show loading overlay
            $('#loadingOverlay').fadeIn();
            $('#downloadBtn').prop('disabled', true).html('<i class="fas fa-spinner fa-spin"></i> Processing...');
            
            // AJAX request
            $.ajax({
                url: window.location.href,
                type: 'POST',
                dataType: 'json',
                data: {
                    download: 1,
                    rasan_no: rasanNo,
                    type: type
                },
                success: function(response) {
                    $('#loadingOverlay').fadeOut();
                    $('#downloadBtn').prop('disabled', false).html('<i class="fas fa-download"></i> Download PDF (₹<?php echo $service_fee; ?>)');
                    
                    if (response.success) {
                        // Update wallet balance if available
                        if (response.new_balance !== undefined) {
                            $('#walletBalance').text('₹' + parseFloat(response.new_balance).toFixed(2));
                        }
                        
                        // Download PDF
                        if (response.pdf_base64) {
                            // Create blob and download
                            const byteCharacters = atob(response.pdf_base64);
                            const byteNumbers = new Array(byteCharacters.length);
                            for (let i = 0; i < byteCharacters.length; i++) {
                                byteNumbers[i] = byteCharacters.charCodeAt(i);
                            }
                            const byteArray = new Uint8Array(byteNumbers);
                            const blob = new Blob([byteArray], { type: 'application/pdf' });
                            const url = window.URL.createObjectURL(blob);
                            
                            // Create download link
                            const a = document.createElement('a');
                            a.href = url;
                            a.download = response.filename || 'ration_card.pdf';
                            document.body.appendChild(a);
                            a.click();
                            
                            // Cleanup
                            setTimeout(() => {
                                window.URL.revokeObjectURL(url);
                                document.body.removeChild(a);
                            }, 100);
                            
                            // Show success message
                            setTimeout(() => {
                                alert(response.message || 'PDF downloaded successfully!');
                            }, 500);
                        } else {
                            alert('Success! ' + response.message);
                        }
                    } else {
                        alert('Error: ' + response.message);
                    }
                },
                error: function(xhr, status, error) {
                    $('#loadingOverlay').fadeOut();
                    $('#downloadBtn').prop('disabled', false).html('<i class="fas fa-download"></i> Download PDF (₹<?php echo $service_fee; ?>)');
                    alert('Network error occurred. Please try again. Error: ' + error);
                }
            });
        });
        
        // Close loading overlay on escape key
        $(document).on('keydown', function(e) {
            if (e.keyCode === 27) { // Escape key
                $('#loadingOverlay').fadeOut();
                $('#downloadBtn').prop('disabled', false).html('<i class="fas fa-download"></i> Download PDF (₹<?php echo $service_fee; ?>)');
            }
        });
    });
    
    // Function to handle base64 to blob conversion
    function base64ToBlob(base64, mimeType) {
        const byteCharacters = atob(base64);
        const byteNumbers = new Array(byteCharacters.length);
        for (let i = 0; i < byteCharacters.length; i++) {
            byteNumbers[i] = byteCharacters.charCodeAt(i);
        }
        const byteArray = new Uint8Array(byteNumbers);
        return new Blob([byteArray], { type: mimeType });
    }
    </script>
</body>
</html>